(ns burningswell.db.signup
  (:require [burningswell.db.emails :as emails]
            [burningswell.db.roles :as roles]
            [burningswell.db.users :as users]
            [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]))

(s/def ::email :burningswell.db.emails/address)
(s/def ::password string?)
(s/def ::username :burningswell.db.users/username)

(s/def ::params
  (s/keys :req-un [::email ::username ::password]))

(defn- insert-user!
  [db username password]
  (->> {:username username
        :crypted-password
        `(crypt ~password (gen_salt "bf"))}
       (users/insert! db)))

(defn- insert-email!
  [db user email]
  (->> {:address email
        :user-id (:id user)}
       (emails/insert! db)))

(defn signup!
  "Sign up a new user and add the `user` role."
  [db {:keys [email username password]}]
  (sql/with-transaction [db db]
    (let [user (insert-user! db username password)
          email (insert-email! db user email)]
      (users/save-primary-email! db user email)
      (users/add-role! db user (roles/user db))
      user)))

(s/fdef signup!
  :args (s/cat :db sql/db? :params ::params))
