(ns burningswell.db.signup
  (:require [burningswell.db.roles :as roles]
            [burningswell.db.users :as users]
            [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]))

(s/def ::email :burningswell.db.users/email)
(s/def ::password string?)
(s/def ::username :burningswell.db.users/username)

(s/def ::params
  (s/keys :req-un [::email ::username ::password]))

(defn- insert-user!
  [db {:keys [username email password]}]
  (first @(sql/insert db :users []
            (sql/values [{:email email
                          :username username
                          :crypted-password
                          `(crypt ~password (gen_salt "bf"))}])
            (sql/returning :*))))

(defn signup!
  "Sign up a new user and add the `surfer` role."
  [db params]
  (let [user (insert-user! db params)]
    (users/add-role! db user (roles/surfer db))
    user))

(s/fdef signup!
  :args (s/cat :db sql/db? :params ::params))
