-- Deploy burningswell-db:add-photo-dislikes-table to pg

BEGIN;

CREATE TABLE dislikes.photos (
  "id" SERIAL PRIMARY KEY,
  "photo-id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "dislikes-photos-photo-id-user-id-idx" ON dislikes.photos ("photo-id", "user-id");

CREATE TRIGGER "dislikes-photos-created-at-trigger"
  BEFORE INSERT ON dislikes.photos FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "dislikes-photos-updated-at-trigger"
  BEFORE UPDATE ON dislikes.photos FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
