-- Deploy create-svm-features-view

BEGIN;

CREATE VIEW "weather"."svm-features" AS
  SELECT "spot-id",
         "spot-name",
         "valid-time",
         "rating",
	 "dirpwsfc",
	 "dirswsfc",
	 "htsgwsfc",
	 "perpwsfc",
	 "perswsfc",
	 "tcdcclm",
	 "tmpsfc",
	 "ugrdsfc",
	 "vgrdsfc",
	 "wdirsfc",
	 "windsfc",
	 "wvdirsfc",
	 "wvpersfc"
    FROM crosstab('SELECT CAST("spots"."name" AS TEXT) || CAST("valid-time" AS TEXT),
			  "spots"."id",
			  "spots"."name",
                          "valid-time",
                          "rating",
			  "variables"."name",
			  "value"
		     FROM "weather"."spot-forecasts"
		     JOIN "weather"."models"
		       ON "models"."id" = "model-id"
		     JOIN "weather"."variables"
		       ON "variables"."id" = "variable-id"
		     JOIN "spots"
		       ON "spots"."id" = "spot-id"
		     JOIN "ratings"
		       ON "ratings"."spot-id" = "spots"."id"
		      AND extract(year from "ratings"."created-at") = extract(year from "spot-forecasts"."valid-time")
		      AND extract(month from "ratings"."created-at") = extract(month from "spot-forecasts"."valid-time")
		      AND extract(day from "ratings"."created-at") = extract(day from "spot-forecasts"."valid-time")
		      AND extract(hour from "ratings"."created-at")::int % 3 = extract(hour from "spot-forecasts"."valid-time")::int % 3
		 ORDER BY 1',
		  'SELECT DISTINCT("name") FROM "weather"."variables" ORDER BY "name"')
      AS ("row-name" TEXT,
          "spot-id" INTEGER,
	  "spot-name" TEXT,
          "valid-time" TIMESTAMP WITH TIME ZONE,
          "rating" INTEGER,
	  "dirpwsfc" FLOAT,
	  "dirswsfc" FLOAT,
	  "htsgwsfc" FLOAT,
	  "perpwsfc" FLOAT,
	  "perswsfc" FLOAT,
	  "tcdcclm" FLOAT,
	  "tmpsfc" FLOAT,
	  "ugrdsfc" FLOAT,
	  "vgrdsfc" FLOAT,
	  "wdirsfc" FLOAT,
	  "windsfc" FLOAT,
	  "wvdirsfc" FLOAT,
	  "wvpersfc" FLOAT);

COMMIT;
