-- Deploy create-roles-users-table

BEGIN;

CREATE TABLE "roles-users" (
  "role-id" INTEGER NOT NULL REFERENCES "roles"("id") ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "roles-users-role-id-user-id-index" ON "roles-users"("role-id", "user-id");

CREATE TRIGGER "roles-users-created-at-trigger"
  BEFORE INSERT ON "roles-users" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "roles-users-updated-at-trigger"
  BEFORE UPDATE ON "roles-users" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
