(ns burningswell.db.materialized-views
  (:require [burningswell.config.core :as config]
            [burningswell.db.connection :as db]
            [burningswell.db.search :as search]
            [burningswell.db.weather :as weather]
            [clojure.tools.logging :as log]
            [commandline.core :refer [print-help with-commandline]]
            [datumbazo.core :refer
             [concurrently refresh-materialized-view with-connection]]
            [environ.core :refer [env]]))

(def views
  "The materialized views."
  [:search.autocomplete])

(defn run
  "Refresh materialized views."
  [config views & [opts]]
  (db/with-db [db config]
    (with-connection [db db]
      (doseq [view views]
        (log/infof "Refreshing materialized view %s." (name view))
        @(refresh-materialized-view
          db view (concurrently (:concurrently opts))))
      views)))

(defn -main [& args]
  (with-commandline [[opts args] args]
    [[h help "Print this help."]
     [c concurrently "Refresh the views concurrently."]]
    (if (:help opts)
      (print-help "materialized-views [OPTION...] [VIEWS,...]")
      (do (run (config/db env)
            (if (empty? args)
              views args)
            opts)))))
