(ns burningswell.kafka.producer
  (:require [burningswell.kafka.core :as core]
            [burningswell.transit :as transit]
            [franzy.serialization.transit.serializers :as ts]
            [peripheral.core :refer [defcomponent]])
  (:import [org.apache.kafka.clients.producer KafkaProducer ProducerRecord]))

(defn- make-client
  "Make a `KafkaProducer` client for `config`."
  [config]
  (KafkaProducer.
   {"bootstrap.servers"
    (or (:bootstrap-servers config) core/default-bootstrap-servers)}
   (ts/transit-serializer :msgpack {:handlers transit/read-handlers})
   (ts/transit-serializer :msgpack {:handlers transit/write-handlers})))

(defcomponent Producer [config]
  :client (make-client config) #(.close %))

(defn producer
  "Returns a Kafka producer component for `config`."
  [& [config]]
  (map->Producer {:config config}))

(defn send!
  "Send a message with `key` and `value` to `topic`."
  [producer topic key value]
  (.send (:client producer) (ProducerRecord. topic key value)))
