(ns burningswell.kafka.core
  (:import org.apache.kafka.clients.consumer.ConsumerConfig
           org.apache.kafka.streams.StreamsConfig
           rads.kafka.transit.MsgpackSerde))

(def default-bootstrap-servers
  "The Kafka default bootstrap servers."
  "localhost:9092")

(defn props [application-id]
  {ConsumerConfig/AUTO_OFFSET_RESET_CONFIG "earliest"
   StreamsConfig/APPLICATION_ID_CONFIG application-id
   StreamsConfig/BOOTSTRAP_SERVERS_CONFIG "localhost:9092"
   StreamsConfig/CACHE_MAX_BYTES_BUFFERING_CONFIG 0
   StreamsConfig/DEFAULT_KEY_SERDE_CLASS_CONFIG (.getName MsgpackSerde)
   StreamsConfig/DEFAULT_VALUE_SERDE_CLASS_CONFIG (.getName MsgpackSerde)})
