(ns burningswell.kafka.admin
  (:require [peripheral.core :refer [defcomponent]]
            [burningswell.kafka.core :as core])
  (:import org.apache.kafka.clients.admin.AdminClient))

(defcomponent Admin [config]
  :client (AdminClient/create (core/props config)))

(comment

  (def admin-client
    (AdminClient/create (core/props {:bootstrap.servers "localhost:9092"})))

  (.createTopics admin-client ["test-topic"])

  @(.names (.listTopics admin-client)))
