(ns burningswell.kafka.deserializer
  (:require [abracad.avro :as avro]
            [abracad.avro.edn :as aedn]
            [burningswell.json :as json]
            [burningswell.transit :as transit]
            [cheshire.core :as cheshire])
  (:import org.apache.kafka.common.serialization.Deserializer))

;; Avro

(defn ->Date
  [timestamp] (java.util.Date. timestamp))

(def avro-readers
  {'inst #'->Date})

(deftype Avro [schema]
  Deserializer
  (configure [_ _ _])
  (deserialize [_ _ data]
    (when data (avro/decode schema data)))
  (close [_]))

(defn avro
  ([] (avro nil))
  ([schema] (Avro. (or schema (aedn/new-schema)))))

;; Json

(deftype Json [opts]
  Deserializer
  (configure [_ _ _])
  (deserialize [_ _ data]
    (when data (json/read-string (String. data))))
  (close [_]))

(defn json
  ([] (json nil))
  ([opts] (Json. opts)))

;; Transit

(deftype Transit [opts]
  Deserializer
  (configure [_ _ _])
  (deserialize [_ _ data]
    (when data (transit/decode data opts)))
  (close [_]))

(defn transit
  ([] (transit nil))
  ([opts] (Transit. (merge {:format :msgpack} opts))))
