(ns burningswell.kafka.serdes.transit
  (:require
   [burningswell.transit :as transit]
   [franzy.serialization.transit.serializers :as serializers]
   [franzy.serialization.transit.deserializers :as deserializers])
  (:gen-class
   :implements [org.apache.kafka.common.serialization.Serde]
   :constructors {[] []}))

(defn -serializer [_]
  (serializers/transit-serializer
   :msgpack {:handlers transit/write-handlers}))

(defn -deserializer [_]
  (deserializers/transit-deserializer
   :msgpack  {:handlers transit/read-handlers}))

(defn -configure [_ _ _])

(defn -close [_])
