(ns burningswell.kafka.serializer
  (:require [abracad.avro :as avro]
            [abracad.avro.edn :as aedn]
            [burningswell.json :as json]
            [burningswell.transit :as transit])
  (:import org.apache.kafka.common.serialization.Serializer))

;; Avro

(extend-type java.util.Date
  avro/AvroSerializable
  (schema-name [_] "inst")
  (field-get [this field] (case field :timestamp (.getTime this)))
  (field-list [this] #{:timestamp}))

(deftype Avro [schema]
  Serializer
  (configure [_ _ _])
  (serialize [_ _ data]
    (when data (avro/binary-encoded schema data)))
  (close [_]))

(defn avro
  ([] (avro nil))
  ([schema] (Avro. (or schema (aedn/new-schema)))))

;; Json

(deftype Json [opts]
  Serializer
  (configure [_ _ _])
  (serialize [_ _ data]
    (when data (.getBytes (json/json-str data))))
  (close [_]))

(defn json
  ([] (json nil))
  ([opts] (Json. opts)))

;; Transit

(deftype Transit [opts]
  Serializer
  (configure [_ _ _])
  (serialize [_ _ data]
    (when data (transit/encode data opts)))
  (close [_]))

(defn transit
  ([] (transit nil))
  ([opts] (Transit. (merge {:format :msgpack} opts))))
