(ns burningswell.metrics.server
  (:require [burningswell.metrics.core :as metrics]
            [burningswell.pedestal.server :as server]
            [io.pedestal.http :as http]
            [io.pedestal.http.route.definition :refer [defroutes]]
            [io.pedestal.interceptor :refer [interceptor]]))

(defroutes routes
  [[["/metrics" {:get [:metrics metrics/export]}]]])

(defn add-metrics
  "Returns an interceptor that adds `metrics` to the context."
  [metrics]
  (interceptor
   {:name ::add-metrics
    :enter #(assoc-in %1 [:request :metrics] metrics)}))

(defn add-interceptors
  "Add standalone server interceptors to `server`."
  [{:keys [metrics] :as server}]
  (update server ::http/interceptors #(vec (cons (add-metrics metrics) %1))))

(defn server
  "Return a new metrics server."
  [config]
  (->  {:init add-interceptors
        :metrics (metrics/metrics)
        :routes routes}
       (merge config)
       (server/server)))
