(defproject burningswell/metrics "0.1.4"
  :description "The Burning Swell metrics"
  :url "https://github.com/burningswell/metrics"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/pedestal "0.1.5"]
                 [iapetos "0.1.2"]
                 [io.prometheus/simpleclient_hotspot "0.0.15"]
                 [org.clojure/clojure "1.9.0-alpha14"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :min-lein-version "2.4.2"
  :profiles {:dev {:dependencies [[ch.qos.logback/logback-core "1.1.9"]
                                  [ch.qos.logback/logback-classic "1.1.9"]
                                  [clj-http "3.4.1"]
                                  [org.slf4j/log4j-over-slf4j "1.7.22"]
                                  [reloaded.repl "0.2.3"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :resource-paths ["dev" "test-resources"]}})
