(ns burningswell.pedestal.interceptor.coerce-body
  (:require [burningswell.json :as json]
            [burningswell.transit :as transit]
            [io.pedestal.interceptor :refer [interceptor]]))

(defn accepted-type
  [context]
  (get-in context [:request :accept :field] "application/edn"))

(defmulti transform-content
  (fn [body content-type] content-type))

(defmethod transform-content "application/edn" [body _]
  (pr-str body))

(defmethod transform-content "application/json" [body _]
  (json/json-str body))

(defmethod transform-content "application/transit+json" [body _]
  (transit/encode body {:format :json}))

(defmethod transform-content "application/transit+msgpack" [body _]
  (transit/encode body {:format :msgpack}))

(defmethod transform-content "text/html" [body _] body)
(defmethod transform-content "text/plain" [body _] body)

(defn coerce-to
  [response content-type]
  (-> response
      (update :body transform-content content-type)
      (assoc-in [:headers "Content-Type"] content-type)))

(def coerce-body
  (interceptor
   {:name ::coerce-body
    :leave
    (fn [context]
      (cond-> context
        (nil? (get-in context [:response :headers "Content-Type"]))
        (update-in [:response] coerce-to (accepted-type context))))}))
