(ns burningswell.rabbitmq.spec
  (:require [burningswell.rabbitmq.client :as client]
            [clojure.spec :as s]))

(s/def ::scheme #{:amqp})
(s/def ::server-name string?)
(s/def ::server-port (s/and int? pos?))
(s/def ::username string?)
(s/def ::password string?)
(s/def ::vhost string?)

(s/def ::config
  (s/keys :req-un [::scheme ::server-name ::server-port ::username
                   ::password ::vhost]))

(s/def ::name string?)

(s/def ::queue
  (s/keys :req-un [::name]))

(s/def ::client
  (s/and client/client? ::config))

(s/fdef client/public-url
  :args (s/cat :config ::config)
  :ret string?)

(s/fdef client/connected?
  :args (s/cat :client ::client)
  :ret boolean?)

(s/fdef client/start-client
  :args (s/cat :client ::client)
  :ret ::client)

(s/fdef client/stop-client
  :args (s/cat :client ::client)
  :ret ::client)

(s/fdef client/client
  :args (s/? ::config)
  :ret ::client)

(s/fdef client/with-connection
  :args (s/cat :binding (s/tuple symbol? any?) :body (s/* any?))
  :ret any?)

(s/fdef client/with-channel
  :args (s/cat :binding (s/tuple symbol? any?) :body (s/* any?))
  :ret any?)

(s/fdef client/declare-message
  :args (s/cat :channel client/channel? :queue ::queue :opts (s/? map?))
  :ret any?)

(s/fdef client/delete-queue
  :args (s/cat :channel client/channel? :queue ::queue :opts (s/? map?))
  :ret any?)

(s/fdef client/read-message
  :args (s/cat :channel client/channel? :queue ::queue :opts (s/? map?))
  :ret any?)
