(defproject burningswell/scheduler "0.1.10"
  :description "The Burning Swell scheduler"
  :url "https://github.com/burningswell/scheduler"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/config "0.1.24"]
                 [burningswell/core "0.0.30"]
                 [burningswell/db "0.0.62"]
                 [burningswell/rabbitmq "0.1.10"]
                 [ch.qos.logback/logback-classic "1.1.5"]
                 [ch.qos.logback/logback-core "1.1.5"]
                 [clojurewerkz/quartzite "2.0.0"]
                 [listora/again"0.1.0"]
                 [netcdf-clj "0.0.11" :exclusions [org.slf4j/slf4j-log4j12]]
                 [org.clojure/clojure "1.8.0"]]
  :plugins [[lein-environ "1.0.2"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :main ^{:skip-aot true} burningswell.scheduler.main
  :profiles {:dev {:dependencies [[org.clojure/tools.namespace "0.2.10"]
                                  [reloaded.repl "0.2.1"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :test {:source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.scheduler.main}}
  :uberjar-name "burningswell-scheduler.jar")
