(ns burningswell.api.specs.commands
  (:require [burningswell.api.specs.ns]
            [clojure.spec.alpha :as s]))

;; Names

(s/def :burningswell.api.command.create/name #{"create"})
(s/def :burningswell.api.command.request/name #{"request"})

;; Command

(s/def :burningswell.api.command/id uuid?)
(s/def :burningswell.api.command/name string?)
(s/def :burningswell.api.command/ns string?)

(s/def :burningswell.api/command
  (s/keys :req-un [:burningswell.api.command/id
                   :burningswell.api.command/ns
                   :burningswell.api.command/name]))

;; Commands

(s/def :burningswell.api.oauth.callback.commands/request
  (s/keys :req-un [:burningswell.api.oauth.callback/ns
                   :burningswell.api.command.request/name]))

(s/def :burningswell.api.page-views.commands/create
  (s/keys :req-un [:burningswell.api.page-views/ns
                   :burningswell.api.command.create/name]))

(s/def :burningswell.api.signin.commands/create
  (s/keys :req-un [:burningswell.api.signin/ns
                   :burningswell.api.command.create/name]))

(s/def :burningswell.api.signup.commands/create
  (s/keys :req-un [:burningswell.api.signup/ns
                   :burningswell.api.command.create/name]))
