(ns burningswell.specs.gen
  (:require [clojure.test.check.generators]
            [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [clojure.string :as str]))

(def iso-3166-1-alpha-2
  "Generate iso-3166-1-alpha-2 country codes."
  (->> (gen/tuple (gen/char-alpha)
                  (gen/char-alpha))
       (gen/fmap (comp str/upper-case (partial apply str)))))

(def iso-3166-1-alpha-3
  "Generate iso-3166-1-alpha-3 country codes."
  (->> (gen/tuple (gen/char-alpha)
                  (gen/char-alpha)
                  (gen/char-alpha))
       (gen/fmap (comp str/upper-case (partial apply str)))))
