(ns burningswell.gen.email
  (:require [burningswell.gen.string :as string]
            [clojure.test.check.generators :as gen]))

(def user
  "A generator for the user of an email address."
  string/non-empty-alphanumeric)

(def server-name
  "A generator for the server-name of an email address."
  string/non-empty-alphanumeric)

(def top-level-domain
  "A generator for the top level domain of an email address."
  string/non-empty-alphanumeric)

(def email
  "A generator for an email address."
  (gen/fmap
   (fn [[user server-name top-level-domain]]
     (str user "@" server-name "." top-level-domain))
   (gen/tuple user server-name top-level-domain)))
