(ns burningswell.specs.gen
  (:require [clojure.test.check.generators]
            [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [clojure.string :as str])
  #?(:cljs (:import goog.Uri)))

(def iso-3166-1-alpha-2
  "Generate iso-3166-1-alpha-2 country codes."
  (->> (gen/tuple (gen/char-alpha)
                  (gen/char-alpha))
       (gen/fmap (comp str/upper-case (partial apply str)))))

(def iso-3166-1-alpha-3
  "Generate iso-3166-1-alpha-3 country codes."
  (->> (gen/tuple (gen/char-alpha)
                  (gen/char-alpha)
                  (gen/char-alpha))
       (gen/fmap (comp str/upper-case (partial apply str)))))

(defn- to-url [x]
  #?(:clj (java.net.URL. (str x))
     :cljs (goog.Uri. (str x))))

(def url
  #?(:clj (gen/fmap to-url (s/gen uri?))
     :cljs (gen/elements
            [(to-url "http://foo.com")
             (to-url "http://bar.com")])))
