(ns burningswell.specs.errors
  (:require [burningswell.specs.core :as core]
            [clojure.pprint :refer [pprint]]
            [clojure.spec.alpha :as s]
            [phrase.alpha :refer [defphraser phrase phrase-first]]))

(def my-country
  {:burningswell.country/id 1
   :burningswell.country/continent "x"
   :burningswell.country/name "xa"
   :burningswell.country/iso-3166-1-alpha-2 "AA"
   :burningswell.country/iso-3166-1-alpha-3 "AAA"})

(s/def ::password
  #(<= 8 (count %)))

(s/def ::name
  (burningswell.specs.core/min-count 2))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defphraser (burningswell.specs.core/min-count n)
  [context problem n]
  (str "is too short (min. " n " characters)"))

(defphraser (burningswell.specs.core/max-count n)
  [context problem n]
  (str "is too long (max. " n " characters)"))

(defphraser (clojure.core/fn [%] (clojure.core/contains? m k))
  [context problem m k]
  (str "must be present"))

(defphraser map?
  [context problem]
  (str "must be a map"))

(defphraser string?
  [context problem]
  (str "must be a string"))

;; (pprint (s/explain-data :burningswell/country {}))
;; (pprint (phrase-first {} :burningswell/country {}))

;; (pprint (s/explain-data ::name "1"))
;; (prn (phrase-first {} ::name "1"))

;; (pprint (s/explain-data :burningswell/country my-country))
;; (pprint (s/explain-data ::password "x"))
;; (pprint (s/explain-data :burningswell.country/iso-3166-1-alpha-2 "x"))

;; (prn (phrase-first {} :burningswell.country/iso-3166-1-alpha-2 "x"))

;; ;; (phrase-first {} :burningswell/country {})

;; ;; (phrase-first {} ::password "1234")

;; (pprint (s/explain-data :burningswell/country my-country))

;; (defn errors [spec data]
;;   (for [problem (::s/problems (s/explain-data spec data))]
;;     problem))

(defn- error-path
  [{:keys [in via] :as problem}]
  (cond
    (not (empty? in))
    in
    (empty? in)
    via))

(defn errors [context spec data]
  (pprint (s/explain-data spec data))
  (reduce
   (fn [errors {:keys [in] :as problem}]
     (update-in errors (error-path problem) conj (phrase context problem)))
   nil (::s/problems (s/explain-data spec data))))

;; (pprint (errors {} :burningswell/country {}))

;; (pprint (errors {} :burningswell.country/continent "x"))

;; (pprint (s/explain-data :burningswell.country/continent "x"))
;; (pprint (s/explain-data :burningswell.country/name "x"))
;; (phrase-first {} :burningswell.country/continent "x")


;; (#'phrase.alpha/normalize-pred 'map?)
;; (#'phrase.alpha/normalize-pred '(burningswell.specs.core/min-count 2))
