(ns burningswell.specs.google
  (:require [burningswell.specs.core :as core]
            [clojure.spec.alpha :as s]))

(s/def :google.profile/gender string?)
(s/def :google.profile/id string?)
(s/def :google.profile/is-plus-user boolean?)
(s/def :google.profile/language string?)
(s/def :google.profile/object-type string?)
(s/def :google.profile/verified boolean?)
(s/def :google.profile/etag string?)
(s/def :google.profile/kind string?)
(s/def :google.profile/circled-by-count nat-int?)
(s/def :google.profile/domain (s/nilable string?))
(s/def :google.profile/url (s/nilable ::core/url-str))
(s/def :google.profile/display-name (s/nilable string?))

(s/def :google.profile.name/family-name string?)
(s/def :google.profile.name/given-name string?)

(s/def :google.profile/name
  (s/keys :req-un [:google.profile.name/family-name
                   :google.profile.name/given-name]))

(s/def :google.profile.image/url ::core/url-str)
(s/def :google.profile.image/is-default boolean?)

(s/def :google.profile/image
  (s/keys :req-un [:google.profile.image/url]))

(s/def :google/profile
  (s/keys :req-un [:google.profile/circled-by-count
                   :google.profile/display-name
                   :google.profile/domain
                   :google.profile/etag
                   :google.profile/gender
                   :google.profile/image
                   :google.profile/is-plus-user
                   :google.profile/kind
                   :google.profile/name
                   :google.profile/object-type
                   :google.profile/url
                   :google.profile/verified]))
