(defproject burningswell/streams "0.1.2"
  :description "The Burning Swell streaming services"
  :url "https://gitlab.com/burningswell/streams"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/core "0.0.74"]
                 [burningswell/config "0.1.53"]
                 [burningswell/db "0.3.31"]
                 [burningswell/kafka "0.1.5"]
                 [burningswell/specs "0.1.4"]
                 [burningswell/transit "0.1.3"]
                 [cheshire "5.8.0"]
                 [com.damballa/abracad "0.4.13"]
                 [com.google.cloud/google-cloud-storage "1.32.0"]
                 [com.google.cloud/google-cloud-vision "1.32.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [expound "0.7.0"]
                 [geocoder-clj "0.2.6"]
                 [image-resizer "0.1.10"]
                 [medley "1.0.0"]
                 [netcdf-clj "0.0.16" :exclusions [com.amazonaws/aws-java-sdk-s3 org.slf4j/slf4j-log4j12]]
                 [org.apache.kafka/kafka-clients "1.1.0"]
                 [org.apache.kafka/kafka-streams "1.1.0"]
                 [org.apache.kafka/kafka_2.12 "1.1.0"]
                 [org.bouncycastle/bcprov-jdk15on "1.59"]
                 [org.clojure/clojure "1.9.0"]
                 [pandect "0.6.1"]
                 [peripheral "0.5.3"]
                 [potemkin "0.4.5"]
                 [rads/kafka.transit "0.3.0" :exclusions [org.apache.kafka/kafka_2.11]]
                 [ring/ring-codec "1.1.1"]
                 [speculate "0.3.1"]]
  :aliases
  {"ci" ["do" ["clean"] ["difftest"] ["lint"]]
   "consumer" ["run" "-m" "burningswell.streams.console.consumer"]
   "lint" ["do" ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:deprecations :local-shadows-var]}
  :main burningswell.streams.main
  :plugins [[lein-environ "1.1.0"]]
  :profiles {:dev {:dependencies [[clj-http-fake "1.0.3"]
                                  [org.apache.kafka/kafka-clients "1.1.0" :classifier "test"]
                                  [org.apache.kafka/kafka-streams "1.1.0" :classifier "test"]
                                  [org.apache.kafka/kafka-streams-test-utils "1.1.0" :classifier "test"]
                                  [org.clojure/test.check "0.9.0"]
                                  [reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.2.6"]
                             [lein-cloverage "1.0.10"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :repl {:repl-options {:init-ns user}
                    :source-paths ["dev"]}
             :test {:resource-paths ["test-resources"]}
             :uberjar {:aot [burningswell.streams.console.consumer]}}
  :repositories {"confluent" "https://packages.confluent.io/maven/"
                 "unidata" "https://artifacts.unidata.ucar.edu/content/repositories/unidata-releases"}
  :uberjar-name "burningswell-streams.jar")

;; Cascalog uses insecure conjars repo
(require 'cemerick.pomegranate.aether)
(cemerick.pomegranate.aether/register-wagon-factory!
 "http" #(org.apache.maven.wagon.providers.http.HttpWagon.))
