(ns burningswell.streams.commands
  (:require [burningswell.streams.core :as core]
            [burningswell.json :as json]
            [peripheral.core :refer [defcomponent]]
            [taoensso.timbre :as log])
  (:import org.apache.kafka.clients.consumer.ConsumerConfig
           burningswell.kafka.serdes.transit
           [org.apache.kafka.streams.kstream Produced]
           [org.apache.kafka.common.serialization Serdes]
           [org.apache.kafka.streams KafkaStreams KeyValue StreamsBuilder StreamsConfig]
           [org.apache.kafka.streams.kstream KeyValueMapper Reducer ValueMapper]
           rads.kafka.transit.MsgpackSerde))

(def topic
  "burningswell.api.commands")

(defn make-stream [props]
  (let [builder (StreamsBuilder.)]
    (-> (.stream builder "burningswell.api.commands")
        (.mapValues (reify ValueMapper
                      (apply [_ v]
                        (println "JSON: " (json/json-str v))
                        (json/json-str v))))
        (.to "burningswell.api.commands.json"
             (Produced/with (transit.) (Serdes/String))))
    (doto (KafkaStreams. (.build builder) (StreamsConfig. props))
      (.start))))

(defcomponent Commands [config]
  :this/as *this*
  :props (core/props config)
  :stream (make-stream props) #(.close %))

(defn commands [& [config]]
  (map->Commands
   {:config (merge {:application.id "commands"} config)}))

(comment
  (require '[abracad.avro :as avro])
  (require '[abracad.avro.edn :as aedn])

  (def schema (aedn/new-schema))

  (->> {:foo ['bar "baz" 1337 #inst "2017-01-01"]}
       (avro/binary-encoded schema)
       (avro/decode schema))

  (import 'org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster))
