(ns burningswell.streams.system
  (:require [burningswell.config.core :as config]
            [burningswell.db.connection :as db]
            [burningswell.kafka.producer :as producer]
            [burningswell.services.facebook :as facebook]
            [burningswell.services.flickr :as flickr]
            [burningswell.services.gravatar :as gravatar]
            [burningswell.services.photos :as photos]
            [burningswell.services.storage :as storage]
            [burningswell.services.vision :as vision]
            [burningswell.streams.api.commands :as commands]
            [burningswell.streams.api.events :as events]
            [burningswell.streams.json :as json]
            [burningswell.streams.page-views :as page-views]
            [burningswell.streams.route-views :as route-views]
            [burningswell.streams.spots.flickr-photos :as spot-photos]
            [burningswell.streams.users.profile-photos :as profile-photos]
            [burningswell.streams.weather.datasets :as weather-datasets]
            [burningswell.streams.weather.datasources :as weather-datasources]
            [burningswell.streams.weather.models :as weather-models]
            [burningswell.streams.weather.spots :as spot-weather]
            [peripheral.core :refer [defsystem+]]))

(defn config [env]
  {:db (config/db env)
   :flickr (config/flickr env)
   :kafka (config/kafka env)
   :storage (:storage (config/google env))})

(defsystem+ Streams
  []
  :db []
  :facebook []
  :gravatar [:db]
  :flickr [:db]
  :json []
  :page-views []
  :photos [:db :storage]
  :pprint-commands []
  :pprint-events []
  :producer []
  :profile-photos [:db :gravatar :facebook :photos]
  :route-views-total []
  :route-views-total-per-user []
  :spot-photos [:db :flickr :photos :vision]
  :spot-weather [:db]
  :storage []
  :weather-datasets [:db :storage]
  :weather-datasources [:db]
  :weather-models [:db])

(defn system
  "Return a new system."
  [{:keys [db flickr kafka storage] :as config}]
  (map->Streams
   {:db (db/new-db db)
    :gravatar (gravatar/service)
    :facebook (facebook/service)
    :flickr (flickr/client flickr)
    :json (json/json kafka)
    :page-views (page-views/page-views kafka)
    :photos (photos/service)
    :pprint-commands (commands/pprint kafka)
    :pprint-events (events/pprint kafka)
    :producer (producer/producer kafka)
    :profile-photos (profile-photos/profile-photos kafka)
    :route-views-total (route-views/total kafka)
    :route-views-total-per-user (route-views/total-per-user kafka)
    :spot-photos (spot-photos/worker kafka)
    :spot-weather (spot-weather/worker kafka)
    :storage (storage/google storage)
    :vision (vision/service)
    :weather-datasets (weather-datasets/worker kafka)
    :weather-datasources (weather-datasources/worker kafka)
    :weather-models (weather-models/worker kafka)}))
