(defproject burningswell/transit "0.1.1"
  :description "The Burning Swell Transit format library."
  :url "https://github.com/burningswell/transit"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.6.1"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[clj-time "0.12.0"]
                 [com.cognitect/transit-clj "0.8.288"]
                 [com.cognitect/transit-cljs "0.8.239"]
                 [geo-clj "0.6.2"]
                 [net.postgis/postgis-jdbc "2.2.1"
                  :exclusions [postgresql org.postgresql/postgresql]]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.9.93" :scope "provided"]
                 [org.postgresql/postgresql "9.4.1209"]
                 [prismatic/schema "1.1.3"]]
  :plugins [[jonase/eastwood "0.2.3"]
            [lein-cljsbuild "1.1.3"]
            [lein-difftest "2.0.0"]
            [lein-doo "0.1.7"]]
  :aliases
  {"ci" ["do"
         ["clean"]
         ["difftest"]
         ["doo" "node" "node" "once"]
         ["doo" "phantom" "none" "once"]
         ["doo" "phantom" "advanced" "once"]
         ["lint"]]
   "lint" ["do"  ["eastwood"]]}
  :cljsbuild
  {:builds
   [{:id "none"
     :compiler
     {:main 'burningswell.transit-test-runner
      :optimizations :none
      :output-dir "target/none"
      :output-to "target/none.js"
      :parallel-build true
      :pretty-print true
      :verbose false}
     :source-paths ["src" "test"]}
    {:id "node"
     :compiler
     {:main 'burningswell.transit-test-runner
      :optimizations :none
      :output-dir "target/node"
      :output-to "target/node.js"
      :parallel-build true
      :pretty-print true
      :target :nodejs
      :verbose false}
     :source-paths ["src" "test"]}
    {:id "advanced"
     :compiler
     {:main 'burningswell.transit-test-runner
      :optimizations :advanced
      :output-dir "target/advanced"
      :output-to "target/advanced.js"
      :parallel-build true
      :pretty-print true
      :verbose false}
     :source-paths ["src" "test"]}]})
