(ns burningswell.weather.router
  (:require [burningswell.weather.web :as web]
            [com.stuartsierra.component :refer [Lifecycle using]]
            [schema.core :as s]))

(defn make-routes [db]
  ["/weather"
   [["" (web/forecasts db)]
    [["/forecast"]
     (web/forecasts db)]]])

(s/defrecord Router [db routes]
  Lifecycle
  (start [component]
    (assoc component :routes (make-routes db)))
  (stop [component]
    (assoc component :routes nil)))

(defn new-router
  "Return a new router component."
  [& [opts]]
  (-> (map->Router opts)
      (using [:db])))
