(ns burningswell.weather.server
  (:require [aleph.http :as http]
            [bidi.vhosts :refer [make-handler vhosts-model]]
            [com.stuartsierra.component :refer [Lifecycle using]]
            [yada.yada :refer [yada]]))

(defn create-vhosts-model [server]
  (vhosts-model
   [[{:scheme :http :host (str "localhost:" (:bind-port server))}]
    (-> server :router :routes)
    [true (yada nil)]]))

(defrecord Server [bind-address bind-port]
  Lifecycle
  (start [component]
    (let [model (create-vhosts-model component)]
      (assoc component
             :vhosts-model model
             :server (http/start-server
                      (make-handler model)
                      {:port bind-port
                       :raw-stream? true}))))
  (stop [component]
    (when-let [server (:server component)]
      (.close server))
    (dissoc component :server)))

(defn new-server
  "Return a new server component."
  [& [opts]]
  (-> (map->Server opts)
      (using [:router])))
