(ns burningswell.web.components.weather-summary
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [burningswell.web.components.star-rating :refer [->star-rating]]
            [burningswell.web.time :as time]
            [goog.format :as format]
            [om.core :as om]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :refer-macros [defhtml html]])
  (:import [goog.date Date Interval]
           [goog.i18n DateTimeFormat]))

(defn format-precision [value & [precision]]
  (format/numericValueToString value (or precision 0)))

(defhtml summary-variable
  [weather class name variable & [precision]]
  (let [name (cljs.core/name name)]
    [:div
     {:class (str class "__" name)}
     [:img {:class (str class "__" name "-icon")
            :src (str "/images/" name ".svg")}]
     [:span {:class (str class "__" name "__value")}
      (format-precision (-> weather variable :value) precision)]
     [:span {:class (str class "__" name "__unit")}
      (-> weather variable :unit)]])  )

(defcomponentk weather-summary
  "The weather summary component."
  [[:data time weather time-zone] owner opts state]
  (init-state [_]
    {:class (or (:class opts) "weather-summary")})
  (will-mount [_]
    (if-let [channel (:channel @state)]
      (go (loop [[time weather] (<! channel)]
            (when (and time weather)
              (om/set-state! owner :weather weather)
              (om/set-state! owner :time time)
              (recur (<! channel)))))))
  (render [_]
    (let [{:keys [class]} (om/get-state owner)]
      (html
       [:div {:class class}
        [:div {:class (str class "__rating_date")}
         (->star-rating
          (:rating weather)
          {:opts
           {:active false
            :class (str class "__rating")
            :on-change (:on-rating opts)}})
         [:div {:class (str class "__date")}
          (time/pretty-time time time-zone)]]
        [:div {:class (str class "__details")}
         (summary-variable weather class :wave-height :htsgwsfc 1)
         (summary-variable weather class :wave-period :perpwsfc)
         (summary-variable weather class :wind :windsfc)
         (summary-variable weather class :temperature :tmpsfc)]]))))
