(ns burningswell.web.modules.regions
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.regions :as regions]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.region-list :refer [region-list]]
            [rum.core :as rum]))

(rum/defc content < rum/static
  "Render the content of the regions page."
  [system {:keys [regions] :as page}]
  (layout
   system page
   [:div.regions__content
    (region-list system regions)]))

(rum/defcs page < (coolant/mixin regions/page)
  "Render the regions page."
  [page system]
  (content system page))

(defmethod render-server :regions [system]
  #?(:clj (->> (coolant/get system regions/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :regions)
