(ns burningswell.web.ui.spot-header
  (:require [burningswell.web.ui.diaporama :as diaporama]
            [burningswell.web.ui.google-map :refer [google-map]]
            [burningswell.web.ui.image :refer [image]]
            [burningswell.web.ui.spot-headline :refer [spot-headline]]
            [rum.core :as rum]))

(defn toggle-type!
  "Toggle the spot header."
  [type]
  (swap! type #(if (= :photo %) :map :photo)))

(rum/defc menu < rum/static
  "Render the spot header menu."
  [spot])

(defn slideshow-timeline
  "Return the timeline for the photo slideshow."
  [photos]
  (for [photo photos]
    {:image (-> photo :images :small :url)
     :duration 5000
     :kenburns
     {:from [ 1 [ 0.5 0.5 ] ]
      :to [ 0.8911303463002942 [ 0.6957547169811321 0.5671378091872792 ] ]}
     :transitionNext {:name "burn" :duration 1000}}))

(rum/defc spot-image < rum/static
  "Render a spot photo."
  [spot photos]
  (image
   {:class "spot-header__image"
    :background "#222222"
    :preload true
    :sizing "cover"
    :fade true
    :src (-> spot :_embedded :photo :images :small :url)}))

(rum/defc spot-slideshow < rum/static
  "Render a spot slideshow."
  [spot photos]
  (when (not-empty photos)
    (diaporama/diaporama
     {:autoplay true
      :class "spot-header__image"
      :key (str "spot-diaporama-" (:id spot))
      :loop true
      :data
      {:timeline (slideshow-timeline photos)
       :resources {}
       :transitions diaporama/transitions}})))

(rum/defcs spot-header < rum/static (rum/local :photo ::type)
  "Render a spot header."
  [state system spot photos]
  (let [type (some-> state ::type deref)]
    [:div.spot-header
     {:class
      (if (= type :photo)
        "spot-header--photo"
        "spot-header--map")}
     (if (= type :photo)
       (spot-image spot photos)
       ;; (spot-slideshow spot photos)
       (google-map
        {:class "spot-header__map"
         :location (:location spot)
         :zoom 7}))
     (spot-headline system spot)
     (menu
      {:type type
       :on-type #(toggle-type! type)})]))
