(ns burningswell.web.mixins.event-handler
  (:require [om-tools.mixin :refer-macros [defmixin]])
  (:import [goog.events EventHandler]))

(defn listen
  "Register an event `handler` for events of `type` on `target`."
  [owner target type handler]
  (.listen (.-event-handler owner) target (name type) handler))

(defn remove-all
  "Remove all registered event handlers."
  [owner]
  (.removeAll (.-event-handler owner)))

(defmixin handler
  (will-mount [owner]
    (set! (.-event-handler owner) (EventHandler.)))
  (will-unmount [owner]
    (remove-all owner)))
