(ns burningswell.web.modules.search
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.search :as search]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.search-list :refer [search-list]]
            [rum.core :as rum]))

(rum/defc content < rum/static
  "Render the content of the search page."
  [system {:keys [results] :as page}]
  (layout
   system page
   [:div.search__content
    (search-list system results)]))

(rum/defcs page < (coolant/mixin search/page)
  "Render the search page."
  [page system]
  (content system page))

(defmethod render-server :search [system]
  #?(:clj (->> (coolant/get system search/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :search)
