(ns burningswell.web.spots-test
  (:require [burningswell.db.spots :as spots]
            [burningswell.web.test :refer :all]
            [clojure.test :refer :all]))

(deftest test-spots
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (is (= (current-layout-link-text webdriver) "Spots"))
    (is (= (current-layout-link-icon webdriver) "place"))))

(deftest test-spots-near-mundaka
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (let [spot (spots/mundaka (-> system :api :db))]
      (browse-to system "/spots")
      (set-location-cookie! webdriver (:location spot))
      (browse-to system "/spots")
      (is (= (take 4 (spot-headline-names webdriver))
             ["Mundaka" "Meñakoz" "São Lorenço" "Coxos"])))))

(deftest test-spots-near-uluwatu
  (with-webdriver-system [{:keys [webdriver] :as system} env]
    (let [spot (spots/uluwatu (-> system :api :db))]
      (browse-to system "/spots")
      (set-location-cookie! webdriver (:location spot))
      (browse-to system "/spots")
      (is (= (take 4 (spot-headline-names webdriver))
             ["Uluwatu" "Padang Padang"])))))
