(ns burningswell.web.stores.region
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn spots-path [region]
  (concat (resources/region-path region) [:spots]))

(defn update-region
  "Update the current region."
  [state region]
  (assoc state :region (resources/region-path region)))

(defn update-spots
  "Update the regions around the current region."
  [state [region spots]]
  (assoc-in state (spots-path region) (map resources/spot-path spots)))

(def store
  "The regions page store."
  (coolant/store
   :region
   {:region nil
    :spots []}
   {:region/region update-region
    :region/spots update-spots}))
