(ns burningswell.web.components.spot-list
  (:require [burningswell.web.components.spot :as spot]
            [burningswell.web.schemas :as schemas]
            [om.core :as om]
            [om-tools.core :refer-macros [defcomponent]]
            [sablono.core :as html :refer-macros [html]]))

(defcomponent spot-list-item
  "A spot list item."
  [spot :- schemas/Spot]
  (render [_]
    (html
     [:li.spot-list-item
      (om/build spot/spot spot)])))

(defcomponent spot-list
  "A list of spots."
  [spots :- [schemas/Spot]]
  (render [_]
    (html
     [:ul.spot-list
      (om/build-all spot-list-item spots {:key :id})])))
