(ns burningswell.web.js-engine-test
  (:require [burningswell.web.js-engine :refer :all]
            [burningswell.web.test :refer :all]
            [clojure.java.io :as io]
            [clojure.test :refer :all])
  (:import [javax.script ScriptEngine]))

(deftest test-evaluate
  (with-js-engine [engine]
    (is (= (evaluate engine "1 + 2") 3))))

(deftest test-render
  (with-js-engine [engine]
    (evaluate engine "var global = this")
    (evaluate engine "global.location = {};")
    (if-let [js (io/resource "nashorn/burningswell.js")]
      (evaluate engine (io/reader js))
      (println "Warning: Nashorn JavaScript file not found."))))

(deftest test-with-js-engine
  (with-js-engine [engine]
    (is (instance? ScriptEngine (:instance engine)))))
