(ns burningswell.web.system-test
  (:require [burningswell.web.system.client :refer :all]
            [burningswell.web.system.server :refer :all]
            [burningswell.web.test :refer :all]
            [clojure.test :refer :all]
            [com.stuartsierra.component :as component]))

(deftest test-client
  (let [system (client (config))]
    (let [started (component/start system)]
      (is (= (component/start started) started))
      (component/stop started))))

(deftest test-server
  (let [system (server (config))]
    (let [started (component/start system)]
      (is (= (component/start started) started))
      (component/stop started))))

(deftest test-headless-system
  (with-headless-system [system env]
    (is (:api system))))
