(ns burningswell.web.components.region
  (:require [burningswell.api.client :as api]
            [burningswell.web.components.google-maps :as maps]
            [burningswell.web.core :as core]
            [burningswell.web.schemas :as schemas]
            [burningswell.web.util :as util]
            [hal.core :as hal]
            [om.core :as om]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :as html :refer-macros [html]]))

(defn- static-map-name [region]
  (let [country (hal/embedded region :country)]
    (str (:name region) ", " (:name country))))

(defcomponentk region
  "A region list item."
  [data :- schemas/Region owner shared]
  (render [_]
    (html
     [:div.region-item
      [:div.region-item__map
       (maps/->static-map (static-map-name data))]
      [:div.region-item__details
       [:h4.region-item__headline
        (util/country-flag (hal/embedded data :country))
        (core/link-to shared (api/path-for :region data) (:name data))]
       [:div.region-item__country
        [:iron-icon {:icon "maps:place"}]
        "Region of "
        (let [country (hal/embedded data :country)]
          (core/link-to shared (api/path-for :country country) (:name country)))
        " with " (:spot-count data) " spots"]]])))
