(ns burningswell.web.getter.spot
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.spot :as spot]
            [burningswell.web.stores.weather :as weather]
            [coolant.core :as coolant]))

(def spot
  "The getter for the region."
  (coolant/getter
   [spot/store resources/store]
   (fn [page resources]
     (resources/resource resources (:spot page)))))

(def spots
  "The getter for the spots around a spot."
  (coolant/getter
   [spot/store spot resources/store]
   (fn [page spot resources]
     (->> (get-in page (spot/spots-path spot))
          (resources/resources resources)))))

(def photos
  "The getter for the spot photos."
  (coolant/getter
   [spot/store spot resources/store]
   (fn [page spot resources]
     (->> (get-in page (spot/photos-path spot))
          (resources/resources resources)))))

(def weather
  "The getter for the spot weather."
  (coolant/getter
   [spot/store weather/store]
   (fn [page weather]
     (get-in weather (:spot page)))))

(def page
  "The getter for the spot page."
  (coolant/getter
   [layout spot spots photos weather]
   (fn [layout spot spots photos weather]
     (->> {:spot spot
           :spots spots
           :photos photos
           :title (:name spot)
           :weather weather}
          (merge layout)))))
