(ns burningswell.web.modules.countries
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.countries :as countries]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.country-list :refer [country-list]]
            [burningswell.web.ui.layout :refer [layout]]
            [rum.core :as rum]))

(rum/defc content < rum/static
  "Render the content of the countries page."
  [system {:keys [countries] :as page}]
  (layout
   system page
   [:div.countries__content
    (country-list system countries)]))

(rum/defcs page < (coolant/mixin countries/page)
  "Render the countries page."
  [page system]
  (content system page))

(defmethod render-server :countries [system]
  #?(:clj (->> (coolant/get system countries/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :countries)
