(ns burningswell.web.ui.country-headline
  (:require [burningswell.web.ui.links :as link-to]
            [burningswell.web.util :as util]
            [rum.core :as rum]))

(rum/defc country-headline < rum/static
  "Render the country headline."
  [system country]
  (when (:name country)
    [:div.country-headline
     [:h6.country-headline__name
      [:img.country-headline__flag
       {:src (util/country-flag-url country)}]
      (link-to/country system country)]
     [:div.country-headline__counts
      [:span.country-headline__spot-count
       (:spot-count country) " spots"]
      " in "
      [:span.country-headline__region-count
       (:region-count country)
       (util/pluralize
        (:region-count country)
        " region"
        " regions")]]]))
