(ns burningswell.web.getter.country
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.country :as country]
            [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(def country
  "The getter for the country."
  (coolant/getter
   [country/store resources/store]
   (fn [page resources]
     (resources/resource resources (:country page)))))

(def regions
  "The getter for the regions."
  (coolant/getter
   [country/store resources/store]
   (fn [page resources]
     (resources/resources resources (:regions page)))))

(def page
  "The getter for the country page."
  (coolant/getter
   [layout country regions]
   (fn [layout country regions]
     (->> {:country country
           :regions regions
           :title (:name country)}
          (merge layout)))))
