(ns burningswell.web.stores.signup
  "The Burning Swell signup page."
  (:require [coolant.core :as coolant]))

(def email-taken-msg
  "Email has already been taken.")

(def username-taken-msg
  "Username has already been taken.")

(defn update-email
  "Update the `value` of the email form field."
  [state value]
  (assoc-in state [:form :email] value))

(defn update-password
  "Update the `value` of the password form field."
  [state value]
  (assoc-in state [:form :password] value))

(defn update-username
  "Update the `value` of the username form field."
  [state value]
  (assoc-in state [:form :username] value))

(defn field-available
  [state field value error]
  (if value
    (update-in state [:errors field] #(if (not= % error) %))
    (assoc-in state [:errors field] error)))

(defn email-available
  [state value]
  (field-available state :email value email-taken-msg))

(defn username-available
  [state value]
  (field-available state :username value username-taken-msg))

(def store
  "The signup store."
  (coolant/store
   :signup
   {:errors
    {:email nil
     :password nil
     :username nil}
    :form
    {:email ""
     :password ""
     :username ""}
    :title "Signup"}
   {:signup/email update-email
    :signup/email-available email-available
    :signup/password update-password
    :signup/username update-username
    :signup/username-available username-available}))
