// Compiled by ClojureScript 1.9.183 {}
goog.provide('com.stuartsierra.dependency');
goog.require('cljs.core');
goog.require('clojure.set');

/**
 * @interface
 */
com.stuartsierra.dependency.DependencyGraph = function(){};

/**
 * Returns the set of immediate dependencies of node.
 */
com.stuartsierra.dependency.immediate_dependencies = (function com$stuartsierra$dependency$immediate_dependencies(graph,node){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$immediate_dependencies$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$immediate_dependencies$arity$2(graph,node);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.immediate_dependencies[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.immediate_dependencies["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.immediate-dependencies",graph);
}
}
}
});

/**
 * Returns the set of immediate dependents of node.
 */
com.stuartsierra.dependency.immediate_dependents = (function com$stuartsierra$dependency$immediate_dependents(graph,node){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$immediate_dependents$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$immediate_dependents$arity$2(graph,node);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.immediate_dependents[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.immediate_dependents["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.immediate-dependents",graph);
}
}
}
});

/**
 * Returns the set of all things which node depends on, directly or
 *  transitively.
 */
com.stuartsierra.dependency.transitive_dependencies = (function com$stuartsierra$dependency$transitive_dependencies(graph,node){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependencies$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependencies$arity$2(graph,node);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.transitive_dependencies[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.transitive_dependencies["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.transitive-dependencies",graph);
}
}
}
});

/**
 * Returns the set of all things which any node in node-set depends
 *  on, directly or transitively.
 */
com.stuartsierra.dependency.transitive_dependencies_set = (function com$stuartsierra$dependency$transitive_dependencies_set(graph,node_set){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependencies_set$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependencies_set$arity$2(graph,node_set);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.transitive_dependencies_set[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node_set);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.transitive_dependencies_set["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node_set);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.transitive-dependencies-set",graph);
}
}
}
});

/**
 * Returns the set of all things which depend upon node, directly or
 *  transitively.
 */
com.stuartsierra.dependency.transitive_dependents = (function com$stuartsierra$dependency$transitive_dependents(graph,node){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependents$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependents$arity$2(graph,node);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.transitive_dependents[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.transitive_dependents["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.transitive-dependents",graph);
}
}
}
});

/**
 * Returns the set of all things which depend upon any node in
 *  node-set, directly or transitively.
 */
com.stuartsierra.dependency.transitive_dependents_set = (function com$stuartsierra$dependency$transitive_dependents_set(graph,node_set){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependents_set$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$transitive_dependents_set$arity$2(graph,node_set);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.transitive_dependents_set[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node_set);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.transitive_dependents_set["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node_set);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.transitive-dependents-set",graph);
}
}
}
});

/**
 * Returns the set of all nodes in graph.
 */
com.stuartsierra.dependency.nodes = (function com$stuartsierra$dependency$nodes(graph){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraph$nodes$arity$1 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraph$nodes$arity$1(graph);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.nodes[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.nodes["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraph.nodes",graph);
}
}
}
});


/**
 * @interface
 */
com.stuartsierra.dependency.DependencyGraphUpdate = function(){};

/**
 * Returns a new graph with a dependency from node to dep ("node depends
 *  on dep"). Forbids circular dependencies.
 */
com.stuartsierra.dependency.depend = (function com$stuartsierra$dependency$depend(graph,node,dep){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraphUpdate$depend$arity$3 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraphUpdate$depend$arity$3(graph,node,dep);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.depend[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node,dep);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.depend["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node,dep);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraphUpdate.depend",graph);
}
}
}
});

/**
 * Returns a new graph with the dependency from node to dep removed.
 */
com.stuartsierra.dependency.remove_edge = (function com$stuartsierra$dependency$remove_edge(graph,node,dep){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraphUpdate$remove_edge$arity$3 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraphUpdate$remove_edge$arity$3(graph,node,dep);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.remove_edge[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node,dep);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.remove_edge["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node,dep);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraphUpdate.remove-edge",graph);
}
}
}
});

/**
 * Returns a new dependency graph with all references to node removed.
 */
com.stuartsierra.dependency.remove_all = (function com$stuartsierra$dependency$remove_all(graph,node){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraphUpdate$remove_all$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraphUpdate$remove_all$arity$2(graph,node);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.remove_all[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.remove_all["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraphUpdate.remove-all",graph);
}
}
}
});

/**
 * Removes the node from the dependency graph without removing it as a
 *  dependency of other nodes. That is, removes all outgoing edges from
 *  node.
 */
com.stuartsierra.dependency.remove_node = (function com$stuartsierra$dependency$remove_node(graph,node){
if((!((graph == null))) && (!((graph.com$stuartsierra$dependency$DependencyGraphUpdate$remove_node$arity$2 == null)))){
return graph.com$stuartsierra$dependency$DependencyGraphUpdate$remove_node$arity$2(graph,node);
} else {
var x__81846__auto__ = (((graph == null))?null:graph);
var m__81847__auto__ = (com.stuartsierra.dependency.remove_node[goog.typeOf(x__81846__auto__)]);
if(!((m__81847__auto__ == null))){
return m__81847__auto__.call(null,graph,node);
} else {
var m__81847__auto____$1 = (com.stuartsierra.dependency.remove_node["_"]);
if(!((m__81847__auto____$1 == null))){
return m__81847__auto____$1.call(null,graph,node);
} else {
throw cljs.core.missing_protocol.call(null,"DependencyGraphUpdate.remove-node",graph);
}
}
}
});

com.stuartsierra.dependency.remove_from_map = (function com$stuartsierra$dependency$remove_from_map(amap,x){
return cljs.core.reduce.call(null,(function (m,p__112568){
var vec__112569 = p__112568;
var k = cljs.core.nth.call(null,vec__112569,(0),null);
var vs = cljs.core.nth.call(null,vec__112569,(1),null);
return cljs.core.assoc.call(null,m,k,cljs.core.disj.call(null,vs,x));
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.dissoc.call(null,amap,x));
});
/**
 * Recursively expands the set of dependency relationships starting
 *   at (get neighbors x), for each x in node-set
 */
com.stuartsierra.dependency.transitive = (function com$stuartsierra$dependency$transitive(neighbors,node_set){
var unexpanded = cljs.core.mapcat.call(null,neighbors,node_set);
var expanded = cljs.core.PersistentHashSet.EMPTY;
while(true){
var temp__6367__auto__ = cljs.core.seq.call(null,unexpanded);
if(temp__6367__auto__){
var vec__112581 = temp__6367__auto__;
var seq__112582 = cljs.core.seq.call(null,vec__112581);
var first__112583 = cljs.core.first.call(null,seq__112582);
var seq__112582__$1 = cljs.core.next.call(null,seq__112582);
var node = first__112583;
var more = seq__112582__$1;
if(cljs.core.contains_QMARK_.call(null,expanded,node)){
var G__112584 = more;
var G__112585 = expanded;
unexpanded = G__112584;
expanded = G__112585;
continue;
} else {
var G__112586 = cljs.core.concat.call(null,more,neighbors.call(null,node));
var G__112587 = cljs.core.conj.call(null,expanded,node);
unexpanded = G__112586;
expanded = G__112587;
continue;
}
} else {
return expanded;
}
break;
}
});
com.stuartsierra.dependency.set_conj = cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {com.stuartsierra.dependency.DependencyGraph}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {com.stuartsierra.dependency.DependencyGraphUpdate}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
com.stuartsierra.dependency.MapDependencyGraph = (function (dependencies,dependents,__meta,__extmap,__hash){
this.dependencies = dependencies;
this.dependents = dependents;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
com.stuartsierra.dependency.MapDependencyGraph.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__81803__auto__,k__81804__auto__){
var self__ = this;
var this__81803__auto____$1 = this;
return cljs.core._lookup.call(null,this__81803__auto____$1,k__81804__auto__,null);
});

com.stuartsierra.dependency.MapDependencyGraph.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__81805__auto__,k112589,else__81806__auto__){
var self__ = this;
var this__81805__auto____$1 = this;
var G__112591 = (((k112589 instanceof cljs.core.Keyword))?k112589.fqn:null);
switch (G__112591) {
case "dependencies":
return self__.dependencies;

break;
