(ns burningswell.web.getter.spot
  (:require [#?(:clj clj-time.core :cljs cljs-time.core)  :refer [interval within?]]
            [#?(:clj clj-time.coerce :cljs cljs-time.coerce)  :refer [to-date-time]]
            [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.spot :as spot]
            [coolant.core :as coolant]))

(def spot
  "The getter for the region."
  (coolant/getter
   [spot/store resources/store]
   (fn [page resources]
     (resources/resource resources (:spot page)))))

(def time-range
  "The getter for the spot weather time range."
  (coolant/getter
   [spot/store spot]
   (fn [page spot]
     (get-in page (spot/time-range-path spot)))))

(def spots
  "The getter for the spots around a spot."
  (coolant/getter
   [spot/store spot resources/store]
   (fn [page spot resources]
     (->> (get-in page (spot/spots-path spot))
          (resources/resources resources)))))

(def photos
  "The getter for the spot photos."
  (coolant/getter
   [spot/store spot resources/store]
   (fn [page spot resources]
     (->> (get-in page (spot/photos-path spot))
          (resources/resources resources)))))

(def weather
  "The getter for the spot weather."
  (coolant/getter
   [spot resources/store]
   (fn [spot resources]
     (get-in resources (resources/spot-weather-path spot)))))

(def weather-table
  "The getter for the spot weather."
  (coolant/getter
   [time-range weather]
   (fn [time-range weather]
     (let [{:keys [start end]} time-range]
       (when (and start end)
         (let [interval (interval (to-date-time start) (to-date-time end))]
           (->> (keys weather)
                (sort)
                (filter #(within? interval %))
                (map #(get weather %)))))))))

(def page
  "The getter for the spot page."
  (coolant/getter
   [layout spot spots photos time-range weather-table]
   (fn [layout spot spots photos time-range weather]
     (->> {:spot spot
           :spots spots
           :photos photos
           :title (:name spot)
           :time-range time-range
           :weather weather}
          (merge layout)))))
