(ns burningswell.web.stores.page
  (:require [coolant.core :as coolant]))

(def breakpoints
  "The media query breakpoints."
  {:xxs 480
   :xs 600
   :s 840
   :m 960
   :l 1280
   :xl 1440
   :xxl 1600})

(defn layout
  "Return the layout based on `width`."
  [{:keys [width]}]
  (when width
    (->> (seq breakpoints)
         (sort-by second)
         (remove #(< width (second %)))
         last first)))

(defn update-current-location
  "Update the current location."
  [state location]
  (assoc state :current-location location))

(defn update-layout
  "update the page layout."
  [state size]
  (assoc state :layout (layout size)))

(defn update-loading
  "Update the loading status."
  [state loading]
  (assoc state :loading loading))

(def store
  "The page store."
  (coolant/store
   :page
   {:layout nil
    :loading false}
   {:current/location update-current-location
    :page/loading update-loading
    :viewport/size update-layout}))
