(ns burningswell.web.ui.search-list
  (:require [burningswell.web.ui.country-card :refer [country-card]]
            [burningswell.web.ui.region-card :refer [region-card]]
            [burningswell.web.ui.spot-card :refer [spot-card]]
            [rum.core :as rum]))

(defn search-list-item-key
  "Return the React key for a result list item."
  [system result]
  (str "search-list-item-" (:id result)))

(rum/defc search-list-item < rum/static {:key-fn search-list-item-key}
  "Render a result list item."
  [system result]
  [:div.search-list__item
   (case (:type result)
     :country (country-card system result)
     :region (region-card system result)
     :spot (spot-card system result))])

(rum/defc search-list < rum/static
  "Render a result list."
  [system results]
  [:div.search-list
   (for [result results]
     (search-list-item system result))])
