(ns burningswell.web.components.spot
  (:require [burningswell.api.client :as api]
            [burningswell.web.components.spot-address :refer [->spot-address]]
            [burningswell.web.components.spot-weather :refer [->spot-weather]]
            [burningswell.web.core :as core]
            [burningswell.web.image :refer [->image]]
            [burningswell.web.util :as util]
            [hal.core :as hal]
            [om.core :as om]
            [om-tools.core :refer-macros [defcomponent]]
            [sablono.core :as html :refer-macros [defhtml html]]))

(defhtml spot-photo
  "Render the spot photo."
  [spot size]
  [:div.spot-item__photo
   (->image
    (-> spot :_embedded :photo :images size :url)
    {:opts
     {:class "spot-item__image"
      :fade true
      :sizing "cover"}})
   [:paper-ripple]])

(defn spot-photo-link
  "Render the spot photo link."
  [owner spot]
  (core/link-to
   (om/get-shared owner)
   (api/path-for :spot spot)
   (spot-photo spot :tiny)))

(defhtml spot-headline
  "Render the spot headline."
  [owner spot]
  (let [system (om/get-shared owner)]
    [:h4.spot-item__headline
     (util/country-flag (hal/embedded spot :country))
     (core/link-to system (api/path-for :spot spot) (:name spot))]))

(defcomponent spot
  "A spot list item."
  [spot owner opts]
  (render [_]
    (html
     [:div.spot-item
      (spot-photo-link owner spot)
      [:div.spot-item__details
       (spot-headline owner spot)
       (->spot-address spot {:opts {:class "spot-item__address"}})
       (->spot-weather spot {:opts {:class "spot-item__weather"}})]])))
